package com.genesyslab.mobile.android.sample;

import android.content.SharedPreferences;
import android.content.SharedPreferences.OnSharedPreferenceChangeListener;
import android.os.Bundle;
import android.preference.EditTextPreference;
import android.preference.ListPreference;
import android.preference.Preference;
import android.preference.PreferenceFragment;
import android.preference.PreferenceGroup;
import android.text.InputType;

public class GenesysSampleFragment extends PreferenceFragment implements OnSharedPreferenceChangeListener {

	@Override
	public void onCreate(Bundle savedInstanceState) {
	    super.onCreate(savedInstanceState);
	    addPreferencesFromResource(R.xml.preferences);
	}

	@Override
	public void onResume() {
	    super.onResume();
	    updatePreferenceSummary(getPreferenceScreen());	    
	    getPreferenceScreen().getSharedPreferences().registerOnSharedPreferenceChangeListener(this);
	}

	@Override
	public void onPause() {
	    super.onPause();
	    getPreferenceScreen().getSharedPreferences().unregisterOnSharedPreferenceChangeListener(this);
	}

	@Override
	public void onSharedPreferenceChanged(SharedPreferences sharedPreferences, String key) {
		Preference pref = findPreference(key);
		updatePreferenceSummary(pref);		
	}
	
	protected void updatePreferenceSummary(Preference pref) {
		if (pref instanceof PreferenceGroup) {
			PreferenceGroup prefGroup = (PreferenceGroup)pref;
		    for (int i = 0; i < prefGroup.getPreferenceCount(); i++) {
		    	updatePreferenceSummary(prefGroup.getPreference(i));
		    }
		}
		else if (pref instanceof EditTextPreference) {
			EditTextPreference textPref = (EditTextPreference)pref;
			boolean isPassword = (textPref.getEditText().getInputType() & InputType.TYPE_TEXT_VARIATION_PASSWORD) != 0;
			if (!isPassword) {
				String text = textPref.getText();
				pref.setSummary(text == null || text.isEmpty() ? "[empty]" : text);
			}
		}
		else if (pref instanceof ListPreference) {
			String value = ((ListPreference)pref).getEntry().toString();
			pref.setSummary(value == null || value.isEmpty() ? "[nothing selected]" : value);
		}
	}
	
}